'This demo has an arc maker as a SUB
'By David Drake
'Minute adjustments by Nally, May 2003

'window stuff
nomainwin
WindowWidth = 300
WindowHeight = 300
open "Drawing Arcs - By David Drake" for graphics as #1
print #1, "trapclose [quit]"
print #1, "color black;backcolor white"
print #1, "down"

'Parameters of arc

startAngleD =  90  ' Start angle given in degrees
                   ' but converted to radians below

startAngle  = (startAngleD / 360) * (2 * 3.14159)

endAngleD  =  270  ' End angle given in degrees
                   ' but converted to radians below

endAngle   = (endAngleD / 360) * (2 * 3.14159)


segments   = 180   ' Segments in arc

centerX    = 150   ' Center of arc X (pixels)
centerY    = 100   ' Center of arc Y (pixels)
radius     = 80    ' Radious of arc (pixels)

call arc startAngle, endAngle, segments, centerX, centerY, radius

wait
[quit]
close #1


'Subroutine that draws arc
sub arc startAngle, endAngle, segments, centerX, centerY, radius

    'endAngle = int(endAngle*100)
    resolution = (endAngle-startAngle)/segments ' Calculates
                                                ' steps in arc based on segments
    x = centerX+radius*cos(startAngle) ' Calculate start point of arc (X)
    y = centerY+radius*sin(startAngle) ' Calculate start point of arc (Y)
    print #1, "place ";x;" ";y         ' Place starting point of arc

    for angle = startAngle to endAngle step resolution ' Sweep arc
        x = centerX+radius*cos(angle) ' Calculate arc point (X)
        y = centerY+radius*sin(angle) ' Calculate arc point (Y)
        print #1, "goto ";x;" ";y     ' Draw line to next point on arc
    next angle

end sub

